using JetBrains.Application;
using JetBrains.Application.DataContext;
using JetBrains.Application.Environment;
using JetBrains.Application.Settings;
using JetBrains.Application.UI.Components;
using JetBrains.Lifetimes;
using JetBrains.ReSharper.Feature.Services.CodeCompletion;
using JetBrains.ReSharper.Feature.Services.Refactorings;
using JetBrains.ReSharper.Refactorings.WorkflowNew;
using JetBrains.Rider.Model.Refactorings;
using ReSharperPlugin.Refix.Wrappers;

namespace ReSharperPlugin.Refix.Components;

[ShellComponent]
internal class CustomBeRefactoringActionHostProvider : BeRefactoringActionHostProvider
{
    private readonly RefactoringInteractionModel _refactoringInteraction;
    private readonly IUIApplication _environment;
    private readonly IFixesManager _fixesManager;
    private readonly IMessaging _messaging;

    public CustomBeRefactoringActionHostProvider(
        RefactoringInteractionModel refactoringInteraction,
        RunsProducts.ProductConfigurations configurations,
        IUIApplication environment,
        ISettingsStore settingsStore,
        Lifetime lifetime,
        IFixesManager fixesManager,
        IMessaging messaging) : base(refactoringInteraction, configurations, environment, settingsStore, lifetime) =>
        (_refactoringInteraction, _environment, _fixesManager, _messaging) =
        (refactoringInteraction, environment, fixesManager, messaging);

    public override void ExecuteRefactoring(IDataContext context, IRefactoringWorkflow workflow)
    {
        context.TryGetComponent<IExternalIntellisenseHost>()?.BeforeExecuteRefactoring(context);
        var host = new WorkflowHostWithBeWizardForm(_refactoringInteraction, _environment);
        var wrappedWorkflow = new RefactoringWorkflowWrapper(workflow, _fixesManager, _messaging);
        WorkflowExecuter.ExecuteWithCustomHost(context, wrappedWorkflow, host);
    }
}
