using JetBrains.Application;
using JetBrains.Application.DataContext;
using JetBrains.Application.Environment;
using JetBrains.Application.Settings;
using JetBrains.Application.UI.Components;
using JetBrains.Lifetimes;
using JetBrains.PsiFeatures.UIInteractive.Refactorings.RefactoringsUI;
using JetBrains.ReSharper.Feature.Services.CodeCompletion;
using JetBrains.ReSharper.Feature.Services.Refactorings;
using JetBrains.ReSharper.Resources.Shell;
using JetBrains.UI.StdApplicationUI;
using ReSharperPlugin.Refix.Wrappers;

namespace ReSharperPlugin.Refix.Components;

[ShellComponent]
internal class CustomVsRefactoringActionHostProvider : WinformsRefactoringActionHostProvider
{
    private readonly IFixesManager _fixesManager;
    private readonly IMessaging _messaging;

    public CustomVsRefactoringActionHostProvider(
        ISettingsStore settingsStore,
        RunsProducts.ProductConfigurations configurations,
        Lifetime lifetime,
        IFixesManager fixesManager,
        IMessaging messaging) : base(settingsStore, configurations, lifetime) =>
        (_fixesManager, _messaging) = (fixesManager, messaging);

    public override void ExecuteRefactoring(IDataContext context, IRefactoringWorkflow workflow)
    {
        context.TryGetComponent<IExternalIntellisenseHost>()?.BeforeExecuteRefactoring(context);
        var host = new WorkflowHostWithWizardForm(
            Shell.Instance.GetComponent<IUIApplication>().MainWindow.TryGetActiveWindow(),
            workflow.Solution.Locks);
        var wrappedWorkflow = new RefactoringWorkflowWrapper(workflow, _fixesManager, _messaging);
        WorkflowExecuter.ExecuteWithCustomHost(context, wrappedWorkflow, host);
    }
}
