using System.Collections.Generic;
using JetBrains.Annotations;
using JetBrains.ReSharper.Feature.Services.Refactorings;
using JetBrains.ReSharper.Feature.Services.Refactorings.Conflicts;
using JetBrains.ReSharper.Psi.Resolve;
using ReSharperPlugin.Refix.Fixes;

namespace ReSharperPlugin.Refix.Components;

public interface IFixesManager
{
    [NotNull] ISet<IReference> GetFixableReferences([NotNull] IRefactoringWorkflow workflow, [NotNull] ConflictSearchResult conflictSearchResult);
    int RunFixes(FixKind kind, [NotNull] IRefactoringWorkflow workflow, [NotNull] ConflictSearchResult conflictSearchResult);
}
