using System;
using System.Collections.Generic;
using System.Linq;
using JetBrains.ProjectModel;
using JetBrains.ReSharper.Feature.Services.Occurrences;
using JetBrains.ReSharper.Feature.Services.Refactorings.Conflicts;

namespace ReSharperPlugin.Refix.Extensions;

public static class ConflictsExtensions
{
    public static IEnumerable<IOccurrence> ToOccurrences(this IEnumerable<IConflict> conflicts, ISolution solution)
    {
        return conflicts.OfType<Conflict>().Distinct(Conflict.ConflictComparer)
            .SelectMany(conflict => conflict.GetOccurrences(solution));
    }

    public static IEnumerable<IOccurrence> ToOccurrences(this IConflict conflict, ISolution solution)
    {
        return (conflict as Conflict)?.GetOccurrences(solution) ?? Array.Empty<IOccurrence>();
    }
}
