using JetBrains.Annotations;
using JetBrains.ReSharper.Feature.Services.Refactorings;
using JetBrains.ReSharper.Feature.Services.Refactorings.Conflicts;
using ReSharperPlugin.Refix.Components;
using ReSharperPlugin.Refix.Fixes;

namespace ReSharperPlugin.Refix.Extensions;

public static class FixesManagerExtensions
{
    public static int RunPreFixes(this IFixesManager fixesManager, [NotNull] IRefactoringWorkflow workflow,
        [NotNull] ConflictSearchResult conflictSearchResult)
    {
        return fixesManager.RunFixes(FixKind.PreFix, workflow, conflictSearchResult);
    }

    public static int RunPostFixes(this IFixesManager fixesManager, [NotNull] IRefactoringWorkflow workflow,
        [NotNull] ConflictSearchResult conflictSearchResult)
    {
        return fixesManager.RunFixes(FixKind.PostFix, workflow, conflictSearchResult);
    }
}
