using System.Collections.Generic;
using System.Linq;
using System.Text;
using JetBrains.ReSharper.Feature.Services.Occurrences;
using JetBrains.ReSharper.Feature.Services.Refactorings.Conflicts.NavigationPoints;
using JetBrains.ReSharper.Psi.Resolve;

namespace ReSharperPlugin.Refix.Extensions;

public static class OccurrencesExtensions
{
    public static IEnumerable<IReference> ToReferences(this IEnumerable<IOccurrence> occurrences)
    {
        return occurrences.Select(ToReference).Where(x => x != null);
    }

    public static IReference ToReference(this IOccurrence occurrence)
    {
        if (occurrence is ReferenceOccurrence refOccurrence)
            return refOccurrence.PrimaryReference ?? refOccurrence.GetReferences().FirstOrDefault();
        if (occurrence is RangeOccurrence rangeOccurrence)
            return rangeOccurrence.GetReferences().FirstOrDefault();
        return null;
    }

    public static string Stringify(this IEnumerable<IOccurrence> occurrences)
    {
        var sb = new StringBuilder();
        foreach (var occurrence in occurrences)
        {
            sb.Append($",\n");
            var occurrenceDetailed = $"({occurrence.GetType()}) {occurrence.DumpToString()}";
            if (occurrence is IConflictOccurrence conflictOccurrence)
                sb.Append($"\n[{conflictOccurrence.Conflict.Description}]:");
            sb.Append($"\n{occurrenceDetailed}");
        }
        return sb.ToString();
    }
}
