using JetBrains.ReSharper.Psi.Transactions;
using JetBrains.Util;

namespace ReSharperPlugin.Refix.Extensions;

public static class PsiTransactionsExtensions
{
    public static bool TryAddUndoRedoHandlerToCurrentTransaction(this IPsiTransactions psiTransactions, IUndoRedoHandler handler)
    {
        var currentTransaction = psiTransactions.DocumentTransactionManager.CurrentTransaction;
        if (currentTransaction is null)
            return false;
        currentTransaction.AddUndoRedoHandler(handler);
        return true;
    }
}
