using System.Collections.Generic;
using JetBrains.Annotations;
using JetBrains.ReSharper.Psi.ExtensionsAPI.Tree;
using JetBrains.ReSharper.Psi.Tree;

namespace ReSharperPlugin.Refix.Extensions;

public static class TreeNodeExtensions
{
    [CanBeNull]
    public static ITreeNode FirstAncestorOfType(this ITreeNode node, NodeType type)
    {
        while (node != null && node.NodeType != type)
            node = node.Parent;
        return node;
    }

    [CanBeNull]
    public static T FirstAncestorOfType<T>(this ITreeNode node) where T : ITreeNode
    {
        while (node != null && node is not T)
            node = node.Parent;
        return (T)node;
    }

    [CanBeNull]
    public static ITreeNode FirstDescendantOfType(this ITreeNode startNode, NodeType type)
    {
        if (startNode == null)
            return null;
        var queue = new Queue<ITreeNode>(new []{ startNode });
        while (queue.Count > 0)
        {
            var node = queue.Dequeue();
            if (node.NodeType == type)
                return node;
            foreach (var child in node.Children())
                queue.Enqueue(child);
        }
        return null;
    }

    [CanBeNull]
    public static T FirstDescendantOfType<T>(this ITreeNode startNode) where T : ITreeNode
    {
        if (startNode == null)
            return default;
        var queue = new Queue<ITreeNode>(new []{ startNode });
        while (queue.Count > 0)
        {
            var node = queue.Dequeue();
            if (node is T soughtNode)
                return soughtNode;
            foreach (var child in node.Children())
                queue.Enqueue(child);
        }
        return default;
    }
}
