using System;
using System.Reflection;
using JetBrains.ReSharper.Feature.Services.Refactorings;
using JetBrains.ReSharper.Feature.Services.Refactorings.Conflicts;
using JetBrains.ReSharper.Psi.Resolve;
using ReSharperPlugin.Refix.Fixes;

namespace ReSharperPlugin.Refix.Extensions;

public static class TypeExtensions
{
    // based on: https://stackoverflow.com/a/457708
    public static bool TryGetWorkflowType(this Type type, out Type workflowType)
    {
        workflowType = null;
        if (!typeof(IFix).IsAssignableFrom(type) || !type.IsClass)
            return false;
        while (type != null && type != typeof(object))
        {
            var generalizedType = type.IsGenericType ? type.GetGenericTypeDefinition() : type;
            if (generalizedType == typeof(Fix<,>))
            {
                var typeArguments = type.GenericTypeArguments;
                if (typeArguments.Length != 2 || !typeof(IRefactoringWorkflow).IsAssignableFrom(typeArguments[1]))
                    return false;
                workflowType = typeArguments[1];
                return true;
            }
            type = type.BaseType;
        }
        return false;
    }

    public static bool TryMakeCreationFunc(this Type fixType, out Func<IRefactoringWorkflow, IFix> creationFunc)
    {
        creationFunc = null;
        var creationMethod = fixType.GetMethod(nameof(NullFix.Create),
            BindingFlags.Public | BindingFlags.Static | BindingFlags.FlattenHierarchy);
        if (creationMethod is null)
            return false;
        creationFunc = workflow => (IFix)creationMethod.Invoke(null, new object[] { workflow });
        return true;
    }

    private class NullFix : Fix<NullFix, IRefactoringWorkflow>
    {
        protected override bool Initialize(IRefactoringWorkflow workflow) => throw new NotImplementedException();
        protected override bool IsApplicableTo(IReference reference) => throw new NotImplementedException();
        public override int Execute(ConflictSearchResult conflictSearchResult) => throw new NotImplementedException();
    }
}
