using System;
using System.Diagnostics.CodeAnalysis;
using System.Runtime.CompilerServices;
using JetBrains.Diagnostics;
using JetBrains.Util.Logging;

namespace ReSharperPlugin.Refix;

public static class Logging
{
    [SuppressMessage("ReSharper", "ExplicitCallerInfoArgument")]
    public static void LogWrapped(Action action, [CallerMemberName] string memberName = null,
        [CallerFilePath] string filePath = null, [CallerLineNumber] int lineNumber = 0)
    {
        LogCallerData(memberName, filePath, lineNumber);
        action();
    }

    [SuppressMessage("ReSharper", "ExplicitCallerInfoArgument")]
    public static T LogWrapped<T>(this Func<T> func, [CallerMemberName] string memberName = null,
        [CallerFilePath] string filePath = null, [CallerLineNumber] int lineNumber = 0)
    {
        LogCallerData(memberName, filePath, lineNumber);
        return func();
    }

    public static void LogCallerData([CallerMemberName] string memberName = null,
        [CallerFilePath] string filePath = null, [CallerLineNumber] int lineNumber = 0)
    {
        Logger.LogMessage(LoggingLevel.TRACE, $"Running {memberName} at {filePath}:{lineNumber}");
    }

    public static void LogException(Exception exception)
    {
        Logger.LogException(exception);
    }
}
