﻿/* Refactoring 14. Convert property to Get method
 * The refactoring DOES result in compile-time errors.
 * Related tests:
 * - TestsMSTest/Rider/m14-property-to-get.cs
 * - TestsNUnit/Rider/n14-property-to-get.cs
 * - TestsXUnit/Rider/x14-property-to-get.cs
 */
namespace Benchmark.Rider;

public class AccessGuard<T> where T : struct
{
    private T _property;

    public T Property
    //       ^^^^^^^^
    // Put the caret above (line 14) and choose "Convert Property to Method(s)" from Refactor This menu.
    // Click "Next" without modifying initial settings and then "Next" again if warned about potential conflicts.
    // Navigate to related tests to see the result.
    {
        get
        {
            Reads++;
            return _property;
        }
        set
        {
            _property = value;
            Writes++;
        }
    }

    public uint Reads { get; private set; }
    public uint Writes { get; private set; }

    public AccessGuard()
    { }

    public AccessGuard(T initial)
    {
        Property = initial;
    }
}
