﻿/* Refactoring 31. Change signature
 * The refactoring DOES result in compile-time errors.
 * Related tests:
 * - TestsMSTest/Rider/m31-change-signature.cs
 * - TestsNUnit/Rider/n31-change-signature.cs
 * - TestsXUnit/Rider/x31-change-signature.cs
 */
namespace Benchmark.Rider;

public static class AreaCalculator
{
    // Put the caret below (line 17) and choose "Transform Parameters" from Refactor This menu.
    // Make sure only "result:double" parameter is checked on the "Select parameters to transform:" list.
    // Choose "Use out parameter as return value" from "Method returns:" drop-down list.
    // Click "Next" to apply the refactoring.
    //                 vvvvvvvvvvvv
    public static void GetForCircle(int radius, out double result) => result = Math.PI * radius * radius;
    //                                               ^^^^^^
    // After refactoring, assignment expression holds a reference to the parameter that no longer exists.

    public static double GetForRectangle(int a, int b) => a * b;
}
