﻿/* Refactoring 37. Invert boolean
 * The refactoring doesn't result in compile-time errors.
 * Related tests:
 * - TestsMSTest/Rider/m37-invert-boolean.cs
 * - TestsNUnit/Rider/n37-invert-boolean.cs
 * - TestsXUnit/Rider/x37-invert-boolean.cs
 */
namespace Benchmark.Rider;

public class IntegerThreshold
{
    private readonly int _threshold;

    public IntegerThreshold(int threshold)
    {
        _threshold = threshold;
    }

    // Put the caret below (line 24) and choose "Invert Boolean" from Refactor This menu.
    // Make sure both "Invert usages of member" and "Invert values inside member" are checked.
    // Click "Next" to apply the refactoring.
    // Navigate to related tests to see the result.
    //          vvvvvvvvvvvvvvvv
    public bool IsAboveThreshold(int value)
    {
        return value > _threshold;
    }
}
