﻿/* Refactorings 39. Pull up method, 40. Pull up field
 * The refactoring doesn't result in compile-time errors.
 * Related tests:
 * - TestsMSTest/Rider/m39-40-pull-up.cs
 * - TestsNUnit/Rider/n39-40-pull-up.cs
 * - TestsXUnit/Rider/x39-40-pull-up.cs
 */
namespace Benchmark.Rider;

public class Parcel : Post
{
    public float Weight { get; set; }
    //           ^^^^^^
    // Put the caret above (line 12) and choose "Pull Members Up" from Refactor This menu.
    // Click "Next" without modifying initial settings.
    public bool IsFragile { get; set; }
}

public class Letter : Post
{
    // Then, remove the line below (line 23) as Rider doesn't check if member is shared between all descendants.
    // Navigate to related tests to see the result.
    public float Weight { get; set; }  // < this line
    public bool IsPriority { get; set; }
}

public class Post
{
    public string Addressee { get; set; } = "";
    public string Sender { get; set; } = "";
}
