﻿/* Refactorings 41. Push down method, 42. Push down field
 * The refactoring DOES result in compile-time errors.
 * Related tests:
 * - TestsMSTest/Rider/m41-42-push-down.cs
 * - TestsNUnit/Rider/n41-42-push-down.cs
 * - TestsXUnit/Rider/x41-42-push-down.cs
 */
namespace Benchmark.Rider;

public class Node
{
    public string Address { get; set; } = "";
    //            ^^^^^^^
    // Put the caret above (line 12) and choose "Push Members Down" from Refactor This menu.
    // Click "Next" without modifying initial settings.
    // Navigate to related tests to see the result.
    public string FriendlyName { get; set; } = "";
}

public class Host : Node
{
    public string OwnerName { get; set; } = null!;
}

public class Server : Node
{
    public string ServiceName { get; set; } = null!;
    public ushort OpenPort { get; set; }
}
