﻿/* Refactoring 50. Extract method
 * The refactoring doesn't result in compile-time errors.
 * Related tests:
 * - TestsMSTest/Rider/m50-extract-method.cs
 * - TestsNUnit/Rider/n50-extract-method.cs
 * - TestsXUnit/Rider/x50-extract-method.cs
 */
namespace Benchmark.Rider;

public class VersionComparer
{
    public static int CompareVersions(string a, string b)
    {
        // Select the lines below (18 - 24) and choose "Extract Method" from Refactor This menu.
        // Set the target visibility to public.
        // Click "Next" to apply the refactoring. If there are any warnings, click "Next" again.
        // There are no tests generated in the refactoring process.
        var parsedVersionA = new Version();
        var splitA = a.Split('.');
        if (splitA.Length != 3)
            throw new ArgumentException("Incorrect format", nameof(a));
        parsedVersionA.Major = int.Parse(splitA[0]);
        parsedVersionA.Minor = int.Parse(splitA[1]);
        parsedVersionA.Patch = int.Parse(splitA[2]);

        var parsedVersionB = new Version();
        var splitB = b.Split('.');
        if (splitB.Length != 3)
            throw new ArgumentException("Incorrect format", nameof(a));
        parsedVersionB.Major = int.Parse(splitB[0]);
        parsedVersionB.Minor = int.Parse(splitB[1]);
        parsedVersionB.Patch = int.Parse(splitB[2]);

        if (parsedVersionA.Major != parsedVersionB.Major)
            return parsedVersionA.Major < parsedVersionB.Major ? -1 : 1;

        if (parsedVersionA.Minor != parsedVersionB.Minor)
            return parsedVersionA.Minor < parsedVersionB.Minor ? -1 : 1;

        if (parsedVersionA.Patch != parsedVersionB.Patch)
            return parsedVersionA.Patch < parsedVersionB.Patch ? -1 : 1;
        return 0;
    }

    public struct Version
    {
        public int Major { get; set; }
        public int Minor { get; set; }
        public int Patch { get; set; }
    }
}
