﻿/* Refactoring 63. To public / To internal / To protected / To private protected / To private
 * The refactoring DOES result in compile-time errors.
 * Related tests:
 * - TestsMSTest/Rider/m63-change-visibility.cs
 * - TestsNUnit/Rider/n63-change-visibility.cs
 * - TestsXUnit/Rider/x63-change-visibility.cs
 */
namespace Benchmark.Rider;

public class Coffee
{
    public static Coffee Instance { get; private set; }

    public bool Empty { get; private set; }

// Put the caret below (line 19) and choose "To private" from Quick Actions menu.
// Navigate to related tests to see the result.
//  vvvvvv             vvvvvv
    public static void Refill()
    {
        Instance = new Coffee();
    }

    static Coffee()
    {
        Instance = new Coffee();
    }

    private Coffee()
    { }

    public void Drink()
    {
        if (Empty)
            throw new Exception();
        Empty = true;
    }
}
