﻿/* Refactoring 14. Convert property to Get method
 * The refactoring DOES result in compile-time errors.
 * Related tests:
 * - TestsMSTest/VS/m14-property-to-get.cs
 * - TestsNUnit/VS/n14-property-to-get.cs
 * - TestsXUnit/VS/x14-property-to-get.cs
 */
namespace Benchmark.VS;

public class AccessGuard<T> where T : struct
{
    private T _property;

// Put the caret below (line 17) and choose "Replace 'Property' with methods" from Quick Actions menu.
// Navigate to related tests to see the result.
//  vvvvvvvvvvvvvvvvv
    public T Property
    {
        get
        {
            Reads++;
            return _property;
        }
        set
        {
            _property = value;
            Writes++;
        }
    }

    public uint Reads { get; private set; }
    public uint Writes { get; private set; }

    public AccessGuard()
    { }

    public AccessGuard(T initial)
    {
        Property = initial;
    }
}
