﻿/* Refactorings 39. Pull up method, 40. Pull up field
 * The refactoring doesn't result in compile-time errors.
 * Related tests:
 * - TestsMSTest/VS/m39-40-pull-up.cs
 * - TestsNUnit/VS/n39-40-pull-up.cs
 * - TestsXUnit/VS/x39-40-pull-up.cs
 */
namespace Benchmark.VS;

public class Parcel : Post
{
    // Put the caret below (line 14) and choose "Pull 'Weight' up" from "Quick Actions" menu.
    //           vvvvvv
    public float Weight { get; set; }
    public bool IsFragile { get; set; }
}

public class Letter : Post
{
    // Then, remove the line below (line 21) as Visual Studio doesn't check if member is shared between all descendants.
    public float Weight { get; set; }  // < this line
    // Navigate to related tests to see the result.
    public bool IsPriority { get; set; }
}

public class Post
{
    public string Addressee { get; set; } = "";
    public string Sender { get; set; } = "";
}
