﻿/* Refactorings 43. Move method, 44. Move field
 * The refactoring DOES result in compile-time errors.
 * Related tests:
 * - TestsMSTest/VS/m43-44-move-member.cs
 * - TestsNUnit/VS/n43-44-move-member.cs
 * - TestsXUnit/VS/x43-44-move-member.cs
 */
namespace Benchmark.VS;

public static class Checked
{
// Put the caret below (line 14) and choose "Move static members to another type..." from Quick Actions menu.
//  vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
    public static bool TryAdd(long a, long b, out long result)
    // Then, click "OK" creating "CheckedHelpers" class.
    // The new class will have internal (not public) visibility.
    // Navigate to related tests to see the result.
    {
        try
        {
            result = checked(a + b);
            return true;
        }
        catch (OverflowException)
        {
            result = 0;
            return false;
        }
    }


    // The other method, not important.

    public static bool TryAdd(sbyte a, sbyte b, out sbyte result)
    {
        try
        {
            result = checked((sbyte)(a + b));
            return true;
        }
        catch (OverflowException)
        {
            result = 0;
            return false;
        }
    }
}
