/* Refactoring 6. Convert anonymous type to tuple
 * The refactoring DOES result in compile-time errors.
 * Related tests:
 * - TestsMSTest/VSCode/m06-anon-to-tuple.cs
 * - TestsNUnit/VSCode/n06-anon-to-tuple.cs
 * - TestsXUnit/VSCode/x06-anon-to-tuple.cs
 */
namespace Benchmark.VSCode;

public class AnonToTuple
{
    public IEnumerable<object> GetRgbColors()
    {
        return new[]
        {
        // Put the caret below (line 19) and choose "Convert to tuple" from Quick Actions menu.
        // The inferred type won't longer match the return type, causing a compilation error.
        //  vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
            new { Name = "White", Red = 0xff, Green = 0xff, Blue = 0xff },
            new { Name = "Black", Red = 0x00, Green = 0x00, Blue = 0x00 },
            new { Name = "Red", Red = 0xff, Green = 0x00, Blue = 0x00 },
        };
    }
}
