/* Refactoring 54. Extract superclass
 * The refactoring DOES result in compile-time errors.
 * Related tests:
 * - TestsMSTest/VSCode/m54-extract-superclass.cs
 * - TestsNUnit/VSCode/n54-extract-superclass.cs
 * - TestsXUnit/VSCode/x54-extract-superclass.cs
 */
namespace Benchmark.VSCode;

public class ExtractSuperclass
{
    private int privateField;
    protected int protectedField;
    public int publicField;

// Put the caret below (line 16) and choose "Extract base class..." from Quick Actions menu.
//  vvvvvvvvvvvvvvvvvvvvvvv
    public int CountToOne()
    {
        var a = 0;
        a++;
        // The references below (lines 24 - 26) will be invalidated as the fields aren't extracted.
        privateField = a;
        protectedField = a;
        publicField = a;
        return a;
    }

    public int CountToFive()
    {
        var a = CountToOne();
        a++;
        a++;
        a++;
        a++;
        privateField = a;
        protectedField = a;
        publicField = a;
        return a;
    }
}
