/* Refactoring 14. Convert property to Get method
 * Tests using the MSTest framework
 * Related application file: BenchmarkConsole/Rider/14-property-to-get.cs
 */
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Benchmark.Rider;

namespace TestsMSTest.Rider;

[TestClass]
public class ReplacePropertyWithMethodsTests
{
    [TestMethod]
    public void TestInitialReadsWritesUsingObjectInitializer()
    {
        var guard = new AccessGuard<char>
        {
            Property = 'a'
        //  ^^^^^^^^
        // After the refactoring is performed, the reference above (line 18) will become invalid.
        };

        Assert.AreEqual(0u, guard.Reads);
        Assert.AreEqual(1u, guard.Writes);
    }

    [TestMethod]
    public void TestInitialReadsWritesUsingParametrizedConstructor()
    {
        var guard = new AccessGuard<long>(5);

        Assert.AreEqual(0u, guard.Reads);
        Assert.AreEqual(1u, guard.Writes);
    }
}
