/* Refactoring 31. Change signature
 * Tests using the MSTest framework
 * Related application file: BenchmarkConsole/Rider/31-change-signature.cs
 */
using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Benchmark.Rider;

namespace TestsMSTest.Rider;

[TestClass]
public class TransformParametersTests
{
    [TestMethod]
    public void TestCircleArea()
    {
        var expectedArea = Math.PI;
        AreaCalculator.GetForCircle(1, out var result);
        //           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
        // The call above (line 18) is modified correctly. The problem lies inside GetForCircle method itself.
        Assert.AreEqual(expectedArea, result);
    }

    [TestMethod]
    public void TestRectangleArea()
    {
        var expectedArea = 3.0;
        Assert.AreEqual(expectedArea, AreaCalculator.GetForRectangle(1, 3));
    }
}
