﻿/* Refactoring 2. Sync namespace and folder name
 * Tests using the MSTest framework
 * Related application file: BenchmarkConsole/VS/02-sync-namespace-folder.cs
 */
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Benchmark.Calculator;
//    ^^^^^^^^^^^^^^^^^^^^
// The using directive isn't updated in the process of refactoring.

namespace TestsMSTest.VS;

[TestClass]
public class ChangeNamespaceToMatchFolderStructureTests
{
    [DataTestMethod]
    [DataRow(0, 0, 0)]
    [DataRow(1, 1, 2)]
    [DataRow(2, 1, 3)]
    [DataRow(-3, 2, -1)]
    [DataRow(-4, -3, -7)]
    [DataRow(32768, 4095, 36863)]
    public void TestAdding(int a, int b, int expectedResult)
    {
        var offsetedCalculator = new SimpleCalculator();
        //                           ^^^^^^^^^^^^^^^^
        // The reference above (line 24) becomes invalid.

        Assert.AreEqual(offsetedCalculator.Add(a, b), expectedResult);
    }
}
