/* Refactorings 43. Move method, 44. Move field
 * Tests using the MSTest framework
 * Related application file: BenchmarkConsole/VS/43-44-move-member.cs
 */
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Benchmark.VS;

namespace TestsMSTest.VS;

[TestClass]
public class MoveStaticMembersToAnotherTypeTests
{
    [TestMethod]
    public void TestLongAddition()
    {
        long a = 5, b = 7;
        bool expectedReturn = true;
        long expectedResult = 12;

        Assert.AreEqual(expectedReturn, Checked.TryAdd(a, b, out var result));
        //                              ^^^^^^^^^^^^^^^^^^^^^^^^^^^
        // After the refactoring is performed, a reference to "Benchmark.VS.CheckedHelpers.TryAdd" should appear above (line 20).
        // Tests will not compile as the class is internal and tests reside in a separate project.
        Assert.AreEqual(expectedResult, result);
    }

    [TestMethod]
    public void TestSbyteAddition()
    {
        sbyte a = 105, b = 57;
        bool expectedReturn = false;

        Assert.AreEqual(expectedReturn, Checked.TryAdd(a, b, out var _));
    }
}
