/* Refactoring 54. Extract superclass
 * Tests using the MSTest framework
 * Related application file: BenchmarkConsole/VSCode/54-extract-superclass.cs
 */
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Benchmark.VSCode;

namespace TestsMSTest.VSCode;

[TestClass]
public class ExtractSuperclassTests
{
    [TestMethod]
    public void TestCountToOne()
    {
        var extractSuperclass = new ExtractSuperclass();
        //                          ^^^^^^^^^^^^^^^^^
        // The test still references original class (line 16), even though it has no need to.
        Assert.AreEqual(1, extractSuperclass.CountToOne());
        //                                   ^^^^^^^^^^
        // The reference above (line 19) isn't modified, but there's an issue inside the method.
    }

    [TestMethod]
    public void TestCountToFive()
    {
        var extractSuperclass = new ExtractSuperclass();
        Assert.AreEqual(5, extractSuperclass.CountToFive());
    }
}
