/* Refactoring 31. Change signature
 * Tests using the NUnit framework
 * Related application file: BenchmarkConsole/Rider/31-change-signature.cs
 */
using System;
using NUnit.Framework;
using Benchmark.Rider;

namespace TestsNUnit.Rider;

public class TransformParametersTests
{
    [Test]
    public void TestCircleArea()
    {
        var expectedArea = Math.PI;
        AreaCalculator.GetForCircle(1, out var result);
        //           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
        // The call above (line 17) is modified correctly. The problem lies inside GetForCircle method itself.
        Assert.AreEqual(expectedArea, result);
    }

    [Test]
    public void TestRectangleArea()
    {
        var expectedArea = 3.0;
        Assert.AreEqual(expectedArea, AreaCalculator.GetForRectangle(1, 3));
    }
}
