﻿/* Refactoring 2. Sync namespace and folder name
 * Tests using the NUnit framework
 * Related application file: BenchmarkConsole/VS/02-sync-namespace-folder.cs
 */
using NUnit.Framework;
using Benchmark.Calculator;
//    ^^^^^^^^^^^^^^^^^^^^
// The using directive isn't updated in the process of refactoring.

namespace TestsNUnit.VS;

public class ChangeNamespaceToMatchFolderStructureTests
{
    [TestCase(0, 0, 0)]
    [TestCase(1, 1, 2)]
    [TestCase(2, 1, 3)]
    [TestCase(-3, 2, -1)]
    [TestCase(-4, -3, -7)]
    [TestCase(32768, 4095, 36863)]
    public void TestAdding(int a, int b, int expectedResult)
    {
        var offsetedCalculator = new SimpleCalculator();
        //                           ^^^^^^^^^^^^^^^^
        // The reference above (line 22) becomes invalid.

        Assert.AreEqual(offsetedCalculator.Add(a, b), expectedResult);
    }
}
