/* Refactoring 14. Convert property to Get method
 * Tests using the NUnit framework
 * Related application file: BenchmarkConsole/VS/14-property-to-get.cs
 */
using NUnit.Framework;
using Benchmark.VS;

namespace TestsNUnit.VS;

public class ReplacePropertyWithMethodsTests
{
    [Test]
    public void TestInitialReadsWritesUsingObjectInitializer()
    {
        var guard = new AccessGuard<char>
        {
            Property = 'a'
        //  ^^^^^^^^
        // After the refactoring is performed, the reference (in line 17) will become invalid.
        };

        Assert.AreEqual(0u, guard.Reads);
        Assert.AreEqual(1u, guard.Writes);
    }

    [Test]
    public void TestInitialReadsWritesUsingParametrizedConstructor()
    {
        var guard = new AccessGuard<long>(5);

        Assert.AreEqual(0u, guard.Reads);
        Assert.AreEqual(1u, guard.Writes);
    }
}
