/* Refactoring 54. Extract superclass
 * Tests using the NUnit framework
 * Related application file: BenchmarkConsole/VSCode/54-extract-superclass.cs
 */
using NUnit.Framework;
using Benchmark.VSCode;

namespace TestsNUnit.VSCode;

public class ExtractSuperclassTests
{
    [Test]
    public void TestCountToOne()
    {
        var extractSuperclass = new ExtractSuperclass();
        //                          ^^^^^^^^^^^^^^^^^
        // The test still references original class (line 15), even though it has no need to.
        Assert.AreEqual(1, extractSuperclass.CountToOne());
        //                                   ^^^^^^^^^^
        // The reference above (line 18) isn't modified, but there's an issue inside the method.
    }

    [Test]
    public void TestCountToFive()
    {
        var extractSuperclass = new ExtractSuperclass();
        Assert.AreEqual(5, extractSuperclass.CountToFive());
    }
}
