/* Refactoring 14. Convert property to Get method
 * Tests using the xUnit.net framework
 * Related application file: BenchmarkConsole/Rider/31-change-signature.cs
 */
using System;
using Xunit;
using Benchmark.Rider;

namespace TestsXUnit.Rider;

public class TransformParametersTests
{
    [Fact]
    public void TestCircleArea()
    {
        var expectedArea = Math.PI;
        AreaCalculator.GetForCircle(1, out var result);
        //           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
        // The call above (line 17) is modified correctly. The problem lies inside GetForCircle method itself.
        Assert.Equal(expectedArea, result);
    }

    [Fact]
    public void TestRectangleArea()
    {
        var expectedArea = 3.0;
        Assert.Equal(expectedArea, AreaCalculator.GetForRectangle(1, 3));
    }
}
