﻿/* Refactoring 2. Sync namespace and folder name
 * Tests using the xUnit.net framework
 * Related application file: BenchmarkConsole/VS/02-sync-namespace-folder.cs
 */
using Xunit;
using Benchmark.Calculator;
//    ^^^^^^^^^^^^^^^^^^^^
// The using directive isn't updated in the process of refactoring.

namespace TestsXUnit.VS;

public class ChangeNamespaceToMatchFolderStructureTests
{
    [Theory]
    [InlineData(0, 0, 0)]
    [InlineData(1, 1, 2)]
    [InlineData(2, 1, 3)]
    [InlineData(-3, 2, -1)]
    [InlineData(-4, -3, -7)]
    [InlineData(32768, 4095, 36863)]
    public void TestAdding(int a, int b, int expectedResult)
    {
        var offsetedCalculator = new SimpleCalculator();
        //                           ^^^^^^^^^^^^^^^^
        // The reference above (line 23) becomes invalid.

        Assert.Equal(offsetedCalculator.Add(a, b), expectedResult);
    }
}
