/* Refactoring 14. Convert property to Get method
 * Tests using the xUnit.net framework
 * Related application file: BenchmarkConsole/VS/14-property-to-get.cs
 */
using Xunit;
using Benchmark.VS;

namespace TestsXUnit.VS;

public class ReplacePropertyWithMethodsTests
{
    [Fact]
    public void TestInitialReadsWritesUsingObjectInitializer()
    {
        var guard = new AccessGuard<char>
        {
            Property = 'a'
        //  ^^^^^^^^
        // After the refactoring is performed, the reference (in line 17) will become invalid.
        };

        Assert.Equal(0u, guard.Reads);
        Assert.Equal(1u, guard.Writes);
    }

    [Fact]
    public void TestInitialReadsWritesUsingParametrizedConstructor()
    {
        var guard = new AccessGuard<long>(5);

        Assert.Equal(0u, guard.Reads);
        Assert.Equal(1u, guard.Writes);
    }
}
