/* Refactorings 43. Move method, 44. Move field
 * Tests using the xUnit.net framework
 * Related application file: BenchmarkConsole/VS/43-44-move-member.cs
 */
using Xunit;
using Benchmark.VS;

namespace TestsXUnit.VS;

public class MoveStaticMembersToAnotherTypeTests
{
    [Fact]
    public void TestLongAddition()
    {
        long a = 5, b = 7;
        bool expectedReturn = true;
        long expectedResult = 12;

        Assert.Equal(expectedReturn, Checked.TryAdd(a, b, out var result));
        //                           ^^^^^^^^^^^^^^^^^^^^^^^^^^^
        // After the refactoring is performed, a reference to "Benchmark.VS.CheckedHelpers.TryAdd" should appear above (line 19).
        // Tests will not compile as the class is internal and tests reside in a separate project.
        Assert.Equal(expectedResult, result);
    }

    [Fact]
    public void TestSbyteAddition()
    {
        sbyte a = 105, b = 57;
        bool expectedReturn = false;

        Assert.Equal(expectedReturn, Checked.TryAdd(a, b, out var _));
    }
}
