/* Refactoring 14. Convert property to Get method
 * Tests using the xUnit.net framework
 * Related application file: BenchmarkConsole/VSCode/14-property-to-get.cs
 */
using Xunit;
using Benchmark.VSCode;

namespace TestsXUnit.VSCode;

public class ReplacePropertyWithMethodsTests
{
    [Fact]
    public void TestInitialReadsWritesUsingObjectInitializer()
    {
        var guard = new AccessGuard<char>
        {
            Property = 'a'
        //  ^^^^^^^^
        // After the refactoring is performed, the reference above (line 17) will become invalid.
        };

        Assert.Equal(0u, guard.Reads);
        Assert.Equal(1u, guard.Writes);
    }

    [Fact]
    public void TestInitialReadsWritesUsingParametrizedConstructor()
    {
        var guard = new AccessGuard<long>(5);

        Assert.Equal(0u, guard.Reads);
        Assert.Equal(1u, guard.Writes);
    }
}
