/* Refactoring 54. Extract superclass
 * Tests using the xUnit.net framework
 * Related application file: BenchmarkConsole/VSCode/54-extract-superclass.cs
 */
using Xunit;
using Benchmark.VSCode;

namespace TestsXUnit.VSCode;

public class ExtractSuperclassTests
{
    [Fact]
    public void TestCountToOne()
    {
        var extractSuperclass = new ExtractSuperclass();
        //                          ^^^^^^^^^^^^^^^^^
        // The test still references original class (line 15), even though it has no need to.
        Assert.Equal(1, extractSuperclass.CountToOne());
        //                                ^^^^^^^^^^
        // The reference above (line 18) isn't modified, but there's an issue inside the method.
    }

    [Fact]
    public void TestCountToFive()
    {
        var extractSuperclass = new ExtractSuperclass();
        Assert.Equal(5, extractSuperclass.CountToFive());
    }
}
