namespace FakeItEasy.Configuration
{
    using System;
    using System.Linq.Expressions;

    /// <inheritdoc />
    /// <summary>
    /// Provides extension methods for <see cref="IAssertConfiguration"/>.
    /// </summary>
    internal abstract class AssertConfigurationBase : IAssertConfiguration
    {
        public abstract UnorderedCallAssertion MustHaveHappened(Repeated repeatConstraint);

        public UnorderedCallAssertion MustHaveHappened(int numberOfTimes, Times timesOption)
        {
            Guard.AgainstNull(timesOption, nameof(timesOption));

            return this.MustHaveHappened(timesOption.ToRepeated(numberOfTimes));
        }

        public UnorderedCallAssertion MustHaveHappenedANumberOfTimesMatching(Expression<Func<int, bool>> predicate)
        {
            Guard.AgainstNull(predicate, nameof(predicate));

            return this.MustHaveHappened(Repeated.Like(predicate));
        }
    }
}
