namespace FakeItEasy.Tests.Configuration
{
    using System.Linq.Expressions;
    using FakeItEasy.Configuration;
    using Xunit;

    public class AssertConfigurationBaseTests
    {
        [Fact]
        public void MustHaveHappenedWithIntAndTimes_should_be_null_guarded()
        {
            // Arrange

            // Act

            // Assert
            Expression<System.Action> call = () => A.Fake<AssertConfigurationBase>().MustHaveHappened(A.Dummy<int>(), Times.Exactly);
            call.Should().BeNullGuarded();
        }

        [Fact]
        public void MustHaveHappenedANumberOfTimesMatching_should_be_null_guarded()
        {
            // Arrange

            // Act

            // Assert
            Expression<System.Action> call = () => A.Fake<AssertConfigurationBase>().MustHaveHappenedANumberOfTimesMatching(n => true);
            call.Should().BeNullGuarded();
        }
    }
}
